#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

const int MAXN = 500100;
const int LOGMAXN = 19;

int n, m;

int dep[MAXN];
int dad[MAXN][LOGMAXN];

int sz[MAXN];
vector<int> adj[MAXN];
vector<int> prv[MAXN];

int lca(int u, int v) {
  if (dep[u] < dep[v]) swap(u, v);
  for (int i = LOGMAXN - 1; i >= 0; --i)
    if (dep[dad[u][i]] >= dep[v])
      u = dad[u][i];
  if (u == v) return u;
  for (int i = LOGMAXN - 1; i >= 0; --i) {
    if (dad[u][i] == dad[v][i])
      continue;
    u = dad[u][i];
    v = dad[v][i];
  }
  return dad[u][0];
}

void dfs(int x) {
  sz[x] = 1;
  for (int y : adj[x]) {
    dfs(y);
    sz[x] += sz[y];
  }
}

void add(int u, int v) {
  adj[u].push_back(v);
  dep[v] = dep[u] + 1;
  dad[v][0] = u;
  for (int i = 1; i < LOGMAXN; ++i)
    dad[v][i] = dad[dad[v][i - 1]][i - 1];
}

int main(void) {
  cin >> n >> m;
  for (int i = 0; i < m; ++i) {
    int u, v;
    cin >> u >> v;
    prv[v - 1].push_back(u - 1);
  }
  for (int i = 1; i < n; ++i) {
    int par = prv[i][0];
    for (int j : prv[i])
      par = lca(par, j);
    add(par, i);
  }
  dfs(0);
  for (int i = 0; i < n; ++i)
    cout << sz[i] - 1 << '\n';
  return 0;
}
